/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionRemoveMultipleOutputs;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.Lazy;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Cloche")
@ZenCodeType.Name(value="mods.immersiveengineering.Cloche")
public class ClocheRecipeManager
implements IRecipeManager<ClocheRecipe> {
    public RecipeType<ClocheRecipe> getRecipeType() {
        return ClocheRecipe.TYPE;
    }

    public void remove(IIngredient output) {
        this.removeRecipe(output);
    }

    @ZenCodeType.Method
    public void removeRecipe(IIngredient output) {
        CraftTweakerAPI.apply((IAction)new AbstractActionRemoveMultipleOutputs<ClocheRecipe>((IRecipeManager)this, output){

            @Override
            public List<ItemStack> getAllOutputs(ClocheRecipe recipe) {
                return recipe.outputs.stream().map(Supplier::get).toList();
            }
        });
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredient seed, IIngredient soil, int time, IItemStack[] outputs, Block renderBlock, @ZenCodeType.Optional(value="\"generic\"") String renderType) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        List<Lazy<ItemStack>> outputList = CrTIngredientUtil.getNonNullList(outputs);
        Ingredient seedIngredient = seed.asVanillaIngredient();
        Ingredient soilIngredient = soil.asVanillaIngredient();
        if (!ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.containsKey(renderType)) {
            throw new IllegalArgumentException("Unknown Render Type: " + renderType);
        }
        ClocheRenderFunction.ClocheRenderReference renderReference = new ClocheRenderFunction.ClocheRenderReference(renderType, renderBlock);
        try {
            ClocheRecipe recipe = new ClocheRecipe(resourceLocation, outputList, seedIngredient, soilIngredient, time, renderReference);
            CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe, null));
        }
        catch (Exception ex) {
            CraftTweakerAPI.LOGGER.error("Could not create Cloche recipe '{}' with renderType '{}': ", (Object)recipePath, (Object)renderType, (Object)ex);
        }
    }
}

